/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.sim;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskProcessLauncher;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.sim.VWSimEnginePropertyPanel;
import filenet.vw.apps.taskman.sim.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import simulator.ISimulator;

public class VWSimEngineNode
extends VWTaskBaseNode {
    private VWSimEnginePropertyPanel m_propertyPanel = null;
    private ISimulator m_simEngine = null;
    private Properties m_properties = null;
    private String m_propertiesPath = null;
    private String m_dtdPath = null;
    private boolean m_isService = false;
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("optimizer_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("optimizer_16.gif");
    protected static final ImageIcon nodeIconS32 = VWImageLoader.createImageIcon("optimizer_stop_32.gif");
    protected static final ImageIcon nodeIconS16 = VWImageLoader.createImageIcon("optimizer_stop_16.gif");
    public static final String XML_NODE_NAME = "ProcessSimulator";

    public VWSimEngineNode(String propertiesPath) throws Exception {
        super(VWResource.ProcessOptimizer, propertiesPath, "TaskManager.ProcessSimulator", 20);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.fromXML(this.getXMLHandler());
        this.initializePaths();
        this.setPSProperties(this.readPropertyFile());
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new VWSimEnginePropertyPanel(this);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel, true, true);
        }
    }

    public void refresh() {
        try {
            this.setSimulator((ISimulator)this.lookupProcess());
            if (!VWTaskCore.getInstance().isAutoMode()) {
                this.m_propertyPanel.refresh();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public void start() throws Exception {
        try {
            VWTaskProcessResult result;
            this.refresh();
            if (this.isStarted()) {
                return;
            }
            this.writeMessage(Level.INFO, VWResource.StartingProcessOptimizer);
            String command = "simulator.Simulator";
            ArrayList<String> javaArgs = new ArrayList<String>();
            StringBuffer cp = new StringBuffer(System.getProperty("java.class.path"));
            String simClassPath = this.getProperty("TaskManager.ProcessSimulator.ClassPath", null);
            if (simClassPath != null) {
                cp.append(File.pathSeparator);
                cp.append(simClassPath);
            }
            cp.append(File.pathSeparator);
            cp.append(this.m_properties.getProperty("simulator.prodpa.jdbcclasspath", ""));
            cp.append(File.pathSeparator);
            cp.append(this.m_properties.getProperty("simulator.simpa.jdbcclasspath", ""));
            javaArgs.add("-cp");
            javaArgs.add(cp.toString());
            if (!this.getLocalHost().equals("")) {
                javaArgs.add("-Djava.rmi.server.hostname=" + this.getLocalHost());
            }
            javaArgs.add("\"-Dsimulator.properties=" + this.m_propertiesPath + "\"");
            javaArgs.add("\"-Dsimulator.dtdpath=" + this.m_dtdPath + "\"");
            int javaMinMem = this.getJavaMinMemory();
            int javaMaxMem = this.getJavaMaxMemory();
            javaMinMem = javaMinMem != -1 && javaMinMem < 1 ? 1 : javaMinMem;
            int n = javaMaxMem = javaMaxMem != -1 && javaMaxMem < 2 ? 2 : javaMaxMem;
            if (javaMinMem != -1) {
                javaArgs.add("-Xms" + javaMinMem + "m");
            }
            if (javaMaxMem != -1) {
                javaArgs.add("-Xmx" + javaMaxMem + "m");
            }
            if ((result = VWTaskProcessLauncher.launchJavaServer(javaArgs, command, false, null, this)).getResult() == null) {
                if (result.getError().length() > 0) {
                    throw new Exception(result.getError());
                }
                throw new Exception(result.getOutput());
            }
            this.setSimulator((ISimulator)result.getResult());
            this.writeMessage(Level.INFO, VWResource.ProcessOptimizerStarted);
        }
        catch (Exception ex) {
            this.m_simEngine = null;
            throw ex;
        }
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh();
        }
    }

    public void stop() throws Exception {
        this.refresh();
        if (!this.isStarted()) {
            return;
        }
        try {
            this.writeMessage(Level.INFO, VWResource.StoppingProcessOptimizer);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setConsoleHandler(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            VWDebug.logInfo("Stopping simulation engine, calling Simulation.stop()...");
            this.m_simEngine.unbind();
        }
        catch (UnmarshalException ex) {
            // empty catch block
        }
        VWDebug.logInfo("Simulation engine has been stopped.");
        this.m_simEngine = null;
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh();
        }
        try {
            this.writeMessage(Level.INFO, VWResource.ProcessOptimizerStopped);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isStarted() {
        return this.m_simEngine != null;
    }

    public Icon getIcon16() {
        if (this.isStarted()) {
            return nodeIcon16;
        }
        return nodeIconS16;
    }

    public Icon getIcon32() {
        if (this.isStarted()) {
            return nodeIcon32;
        }
        return nodeIconS32;
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "simulator.htm");
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        theBuffer.append("\t<ProcessSimulator ");
        theBuffer.append(this.getAutoStartAttributeString() + "/>\n");
    }

    private void fromXML(VWTaskXMLHandler xmlHandler) {
        try {
            if (xmlHandler == null) {
                return;
            }
            Node node = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), XML_NODE_NAME);
            if (node == null || node.getNodeType() != 1) {
                return;
            }
            Element ele = (Element)node;
            this.setAutoStartEnabled(ele);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object lookupProcess() throws Exception {
        ISimulator simulator = null;
        Exception ex = null;
        try {
            String serviceName = this.getPSServiceName();
            int registryPort = this.getRegistryPort();
            String url = "rmi://localhost:" + Integer.toString(registryPort) + "/" + serviceName;
            simulator = (ISimulator)Naming.lookup(url);
            simulator.ping();
        }
        catch (NotBoundException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        if (ex != null) {
            VWDebug.logInfo("VWSimEngineNode::lookupProcess() - " + ex.getLocalizedMessage());
            simulator = null;
        }
        return simulator;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
                this.start();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
                this.stop();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH) == 0) {
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{VWTaskActionCommand.START, VWTaskActionCommand.STOP, "Add Separator", VWTaskActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
            return this.showStartIcon();
        }
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
            return this.showStopIcon();
        }
        return true;
    }

    public boolean showStartIcon() {
        return !this.isStarted();
    }

    public boolean showStopIcon() {
        return this.isStarted() && !this.m_isService;
    }

    public boolean showDeleteIcon() {
        return false;
    }

    public boolean showPropertyIcon() {
        return true;
    }

    public boolean showCommitIcon() {
        return false;
    }

    public boolean showDiscardIcon() {
        return false;
    }

    protected Properties getPSProperties() {
        return this.m_properties;
    }

    protected void setPSProperties(Properties props) {
        this.m_properties = props;
    }

    protected String getPSPropertiesPath() {
        return this.m_propertiesPath;
    }

    private int getRegistryPort() {
        try {
            String strPort = this.m_properties.getProperty("simulator.serviceport", "32771");
            return Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            return 32771;
        }
    }

    private int getJavaMinMemory() {
        int javaMinMemory = -1;
        try {
            javaMinMemory = Integer.parseInt(this.m_properties.getProperty("simulator.JavaMinMem", ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return javaMinMemory;
    }

    private int getJavaMaxMemory() {
        int javaMaxMemory = -1;
        try {
            javaMaxMemory = Integer.parseInt(this.m_properties.getProperty("simulator.JavaMaxMem", ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return javaMaxMemory;
    }

    private String getPSServiceName() {
        return this.m_properties.getProperty("simulator.servicename", "WorkflowSimulator");
    }

    public String getLocalHost() {
        String localHost = "";
        try {
            localHost = this.m_properties.getProperty("simulator.service.localhost", "");
            if (localHost.equals("")) {
                localHost = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return localHost;
    }

    private void setSimulator(ISimulator simulator) throws Exception {
        try {
            this.m_simEngine = simulator;
            if (simulator != null) {
                try {
                    this.setConsoleHandler(simulator.getConsoleHandler());
                }
                catch (Exception e) {
                    VWDebug.logException(e, "Error while setting the console handler for Process Simulator.");
                }
            } else {
                this.setConsoleHandler(null);
            }
        }
        catch (Exception e) {
            this.m_simEngine = null;
            throw e;
        }
    }

    private void initializePaths() {
        String installDir = this.getProperty("TaskManager.ProcessSimulator.Install");
        if (!installDir.endsWith(File.separator)) {
            installDir = installDir + File.separator;
        }
        String propertiesPath = installDir + "cvsim" + File.separator + "properties.txt";
        String dtdPath = "file:/" + this.backSlashToForwardSlash(installDir + "cvsim" + File.separator + "dtd");
        this.m_propertiesPath = this.getProperty("TaskManager.ProcessSimulator.Props", propertiesPath);
        this.m_dtdPath = this.getProperty("TaskManager.ProcessSimulator.DTD", dtdPath);
    }

    private String backSlashToForwardSlash(String path) {
        StringBuffer buffer = new StringBuffer(path);
        for (int index = 0; index < buffer.length(); ++index) {
            if (buffer.charAt(index) != '\\') continue;
            buffer.replace(index, index + 1, "/");
        }
        return buffer.toString();
    }

    private Properties readPropertyFile() throws VWException {
        File propertiesFile = new File(this.m_propertiesPath);
        if (!propertiesFile.exists()) {
            throw new VWException("vw.apps.taskman.sim.VWSimEnginePropertyPanel.PropsFileDoesNotExist", "Could not locate {0} properties file: " + this.m_propertiesPath, VWResource.ProcessOptimizer);
        }
        FileInputStream propFile = null;
        try {
            propFile = new FileInputStream(this.m_propertiesPath);
            Properties properties = new Properties();
            properties.load(propFile);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            throw new VWException("vw.apps.taskman.sim.VWSimEnginePropertyPanel.ErrorReadingPropsFile", "Error reading {0} properties file " + this.m_propertiesPath + " : {1}", VWResource.ProcessOptimizer, e.getLocalizedMessage());
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                    propFile = null;
                }
                catch (Exception e) {}
            }
        }
    }
}

